//
//  MiscMergeEngine.h
//            Written by Don Yacktman and Carl Lindberg
//        Copyright 1998 by Don Yacktman and Carl Lindberg.
//                     All rights reserved.
//      This notice may not be removed from this source code.
//
//	This header is included in the MiscKit by permission from the author
//	and its use is governed by the MiscKit license, found in the file
//	"License.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.
//	

#import <Foundation/NSObject.h>
#import <Foundation/NSString.h> 

@class NSMutableString, NSMutableArray, NSMutableDictionary, NSArray;
@class MiscMergeTemplate, MiscMergeCommand, MiscMergeCommandBlock;

@interface MiscMergeEngine : NSObject
{
	NSMutableDictionary *userInfo;
	NSMutableDictionary *engineSymbols;
	NSMutableDictionary *localSymbols;
	MiscMergeTemplate   *template;
	id              	currentObject;
	NSMutableArray  	*contextStack;
	NSMutableArray  	*commandStack;
	NSMutableString 	*outputString;
	MiscMergeEngine     *parentMerge;
	id                  driver;
	BOOL				aborted;
	BOOL				keepDelimiters;
	BOOL				useRecursiveLookups;
    
    BOOL                isRawRTF;
}

/*" Initializing "*/
- init;
- initWithTemplate:(MiscMergeTemplate *)aTemplate;

/*" Setting/getting attributes "*/
- (NSMutableDictionary *)userInfo;
- (id)mainObject;
- (MiscMergeTemplate *)template;
- (MiscMergeEngine *)parentMerge;
- (void)setMainObject:(id)anObject;
- (void)setTemplate:(MiscMergeTemplate *)aTemplate;
- (void)setParentMerge:(MiscMergeEngine *)anEngine;

/*" Manipulating context variables "*/
+ (NSMutableDictionary *)globalSymbolsDictionary;
+ (void)setGlobalValue:(id)anObject forKey:(NSString *)aKey;
+ (void)removeGlobalValueForKey:(NSString *)aKey;
+ (id)globalValueForKey:(NSString *)aKey;
- (void)setGlobalValue:(id)anObject forKey:(NSString *)aKey;
- (void)removeGlobalValueForKey:(NSString *)aKey;
- (id)globalValueForKey:(NSString *)aKey;

- (void)setEngineValue:(id)anObject forKey:(NSString *)aKey;
- (void)removeEngineValueForKey:(NSString *)aKey;
- (id)engineValueForKey:(NSString *)aKey;

- (void)setLocalValue:(id)anObject forKey:(NSString *)aKey;
- (void)removeLocalValueForKey:(NSString *)aKey;
- (id)localValueForKey:(NSString *)aKey;


/*" Executing the merge "*/
- (NSString *)execute:sender;
- (NSString *)executeWithObject:(id)anObject sender:sender;
- (NSArray *)executeWithObjects:(NSArray *)objects sender:sender;
- (NSArray *)executeWithObjects:(NSArray *)objects duplicates: (int)dupes sender:sender;

/*" Getting the output "*/
- (NSString *)removeObjectReplacementCharacter:(NSMutableString *)aString;
- (NSString *)outputString;

/*" Primitives that may be used by MiscMergeCommands "*/
- (void)executeCommand:(MiscMergeCommand *)command;
- (void)executeCommandBlock:(MiscMergeCommandBlock *)block;
- (void)addContextObject:(id)anObject;
- (void)removeContextObject:(id)anObject;
- (id)valueForField:(NSString *)fieldName;
- (void)appendToOutput:(NSString *)aString;
- (void)abortMerge;
- (void)advanceRecord;

/*" Merge Conveniences "*/
// handles RTF, text or HTML, encoding of 0 skips encoding process
+ (BOOL)mergeObject:(id)object intoFileAtPath:(NSString *)aPath usingStartDelimeter:(NSString *)start endDelimeter:(NSString *)end optionalOutputEncoding:(NSStringEncoding)encoding;

// handles pages documents. Expects the pages document wrapper. The index file should be gzipped. Pages does not like < or > or <$ and $> as delimiters. [ and ] are recommended.
+ (BOOL)mergeObject:(id)object intoPagesDocumentAtPath:(NSString *)aPath usingStartDelimeter:(NSString *)start endDelimeter:(NSString *)end optionalOutputEncoding:(NSStringEncoding)encoding;

+ (BOOL)mergeObject:(id)object intoKeynoteDocumentAtPath:(NSString *)aPath usingStartDelimeter:(NSString *)start endDelimeter:(NSString *)end optionalOutputEncoding:(NSStringEncoding)encoding;


- (BOOL)isRawRTF;
- (void)setRawRTF:(BOOL)flag;

@end
